{********************************************
; File: Print.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT PRINT;
INTERFACE
USES TYPES,QUICKDRAW,EVENTS,CONTROLS,WINDOWS,LINEEDIT,DIALOGS;
CONST


{ Error Codes }
pntrConFailed = $1308;  { connection to the printer failed }
memFullErr = $FF80;
ioAbort = $FFE5;
prAbort = $0080;
missingDriver = $1301;  { specified driver not in system/drivers }
portNotOn = $1302;  { specified port not selected in ctl panel }
noPrintRecord = $1303;  { no print record was given }
badLaserPrep = $1304;  { laser prep in laser writer incompatible }
badLPFile = $1305;  { laser prep in system/drivers incompatible }
papConnNotOpen = $1306;  { cannot connect to laser writer }
papReadWriteErr = $1307;  { apple talk PAPRead or PAPWrite error }
ptrConnFailed = $1308;  { cannot establish connection with imagewriter }
badLoadParam = $1309;  { parameter for load/unload is invalid }
callNotSupported = $130A;  { toolcall made is not supported by this version }
startUpAlreadyMade = $1321;  { low level startup already made }
invalidCtlVal = $1322;  { invalid control value had been spec'd }

{ whichDriver Codes }
bothDrivers = $0;  { input to PMLoadDriver and PMUnloadDriver }
printerDriver = $0001;  { input to PMLoadDriver and PMUnloadDriver }
portDriver = $0002;  { input to PMLoadDriver and PMUnloadDriver }

{ Other Constants }
prPortrait = $0000;
prLandscape = $0001;
prImageWriter = $0001;
prImageWriterLQ = $0002;
prLaserWriter = $0003;
prEpson = $0004;
prBlackWhite = $0001;
prColor = $0002;
bDraftLoop = $0000;
bSpoolLoop = $0080;

TYPE
PrPrinterSpecRec = RECORD
    prPrinterType : Integer;
    prCharacteristics : Integer;
END;
PrInfoRecHndl = ^PrInfoRecPtr;
PrInfoRecPtr = ^PrInfoRec;
PrInfoRec = RECORD
    iDev : Integer; { reserved for internal use }
    iVRes : Integer; { vertical resolution of printer }
    iHRes : Integer; { horizontal resolution of printer }
    rPage : Rect; { defining page rectangle }
END;
PrJobRecPtr = ^PrJobRec;
PrJobRec = PACKED RECORD
    iFstPage : Integer; { first page to print }
    iLstPage : Integer; { last page to print }
    iCopies : Integer; { number of copies }
    bJDocLoop : Byte; { printing method }
    fFromUser : Byte; { used internally }
    pIdleProc : WordProcPtr; { background procedure }
    pFileName : Ptr; { spool file name }
    iFileVol : Integer; { spool file volume reference number }
    bFileVers : Byte; { spool file version number }
    bJobX : Byte; { used internally }
END;
PrStyleRecHndl = ^PrStyleRecPtr;
PrStyleRecPtr = ^PrStyleRec;
PrStyleRec = RECORD
    wDev : Integer; { output quality information }
    internA : ARRAY[1..3] OF Integer; { for internal use }
    feed : Integer; { paper feed type }
    paperType : Integer; { paper type }
    crWidth : Integer; { carriage Width for image writer or vertical sizing for lazer writer }
    reduction : Integer; { % reduction, laser writer only }
    internB : Integer; { for internal use }
END;
PrRecHndl = ^PrRecPtr;
PrRecPtr = ^PrRec;
PrRec = RECORD
    prVersion : Integer; { print manager version }
    prInfo : PrInfoRec; { printer infomation subrecord }
    rPaper : Rect; { Defining paper rectangle }
    prStl : PrStyleRec; { style subrecord }
    prInfoPT : PACKED ARRAY[1..14] OF Byte; { reserved for internal use }
    prXInfo : PACKED ARRAY[1..24] OF Byte; { reserved for internal use }
    prJob : PrJobRec; { job subrecord }
    printX : PACKED ARRAY[1..38] OF Byte; { reserved for future use }
    iReserved : Integer; { reserved for internal use }
END;
PrStatusRecHndl = ^PrStatusRecPtr;
PrStatusRecPtr = ^PrStatusRec;
PrStatusRec = RECORD
    iTotPages : Integer; { number of pages in spool file }
    iCurPage : Integer; { page being printed }
    iTotCopies : Integer; { number of copies requested }
    iCurCopy : Integer; { copy being printed }
    iTotBands : Integer; { reserved for internal use }
    iCurBand : Integer; { reserved for internal use }
    fPgDirty : Boolean; { TRUE if started printing page }
    fImaging : Integer; { reserved for internal use }
    hPrint : PrRecHndl; { handle of print record }
    pPrPort : GrafPortPtr; { pointer to grafport being use for printing }
    hPic : Longint; { reserved for internal use }
END;
PROCEDURE PMBootInit   ;
PROCEDURE PMLoadDriver ( whichDriver:Integer)  ;
PROCEDURE PMReset   ;
PROCEDURE PMShutDown   ;
PROCEDURE PMStartUp ( userID:Integer; dPageAddr:Integer)  ;
FUNCTION PMStatus  : Boolean ;
PROCEDURE PMUnloadDriver ( whichDriver:Integer)  ;
FUNCTION PMVersion  : Integer ;
FUNCTION PrChoosePrinter  : Boolean ;
FUNCTION PrChooser  : Boolean ;
PROCEDURE PrCloseDoc ( printGrafPortPtr:GrafPortPtr)  ;
PROCEDURE PrClosePage ( printGrafPortPtr:GrafPortPtr)  ;
PROCEDURE PrDefault ( printRecordHandle:PrRecHndl)  ;
FUNCTION PrDriverVer  : Integer ;
FUNCTION PrError  : Integer ;
FUNCTION PrGetDocName  : StringPtr ;
FUNCTION PrGetNetworkName  : StringPtr ;
FUNCTION PrGetPgOrientation ( prRecordHandle:PrRecHndl) : Integer ;
FUNCTION PrGetPortDvrName  : StringPtr ;
FUNCTION PrGetPrinterDvrName  : StringPtr ;
FUNCTION PrGetPrinterSpecs  : PrPrinterSpecRec ;
FUNCTION PrGetUserName  : StringPtr ;
FUNCTION PrGetZoneName  : StringPtr ;
FUNCTION PrJobDialog ( printRecordHandle:PrRecHndl) : Boolean ;
FUNCTION PrOpenDoc ( printRecordHandle:PrRecHndl; printGrafPortPtr:GrafPortPtr) : GrafPortPtr ;
PROCEDURE PrOpenPage ( printGrafPortPtr:GrafPortPtr; pageFramePtr:RectPtr)  ;
PROCEDURE PrPicFile ( printRecordHandle:PrRecHndl; printGrafPortPtr:GrafPortPtr; statusRecPtr:PrStatusRecPtr)  ;
PROCEDURE PrPixelMap ( srcLocPtr:LocInfo; srcRectPtr:Rect; colorFlag:Boolean)  ;
FUNCTION PrPortVer  : Integer ;
PROCEDURE PrSetDocName ( DocNamePtr:StringPtr)  ;
PROCEDURE PrSetError ( errorNumber:Integer)  ;
FUNCTION PrStlDialog ( printRecordHandle:PrRecHndl) : Boolean ;
FUNCTION PrValidate ( printRecordHandle:PrRecHndl) : Boolean ;
IMPLEMENTATION
END.
